/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.publish.ivy.internal.artifact.AbstractIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ArchiveTaskBasedIvyArtifact
extends AbstractIvyArtifact {
    private final AbstractArchiveTask archiveTask;
    private final IvyPublicationIdentity identity;
    private final TaskDependencyInternal buildDependencies;

    public ArchiveTaskBasedIvyArtifact(AbstractArchiveTask archiveTask, IvyPublicationIdentity identity) {
        this.archiveTask = archiveTask;
        this.identity = identity;
        this.buildDependencies = new DefaultTaskDependency(null, ImmutableSet.of((Object)archiveTask));
    }

    @Override
    protected String getDefaultName() {
        return this.identity.getModule();
    }

    @Override
    protected String getDefaultType() {
        return (String)this.archiveTask.getArchiveExtension().getOrNull();
    }

    @Override
    protected String getDefaultExtension() {
        return (String)this.archiveTask.getArchiveExtension().getOrNull();
    }

    @Override
    protected String getDefaultClassifier() {
        return (String)this.archiveTask.getArchiveClassifier().getOrNull();
    }

    @Override
    protected String getDefaultConf() {
        return null;
    }

    @Override
    protected TaskDependency getDefaultBuildDependencies() {
        return this.buildDependencies;
    }

    public File getFile() {
        return ((RegularFile)this.archiveTask.getArchiveFile().get()).getAsFile();
    }

    public boolean shouldBePublished() {
        return this.archiveTask.isEnabled();
    }
}

