/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport;", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "mapping", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "innerClassConstructors", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerThisFieldSymbols", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "innerClass", "getOuterThisField", "backend.js"})
public final class JsInnerClassesSupport
implements InnerClassesSupport {
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final Mapping.Delegate<IrClass, IrField> outerThisFieldSymbols;
    @NotNull
    private final Mapping.Delegate<IrConstructor, IrConstructor> innerClassConstructors;
    @NotNull
    private final Mapping.Delegate<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;

    public JsInnerClassesSupport(@NotNull JsMapping mapping2, @NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter((Object)mapping2, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        this.irFactory = irFactory;
        this.outerThisFieldSymbols = mapping2.getOuterThisFieldSymbols();
        this.innerClassConstructors = mapping2.getInnerClassConstructors();
        this.originalInnerClassPrimaryConstructorByClass = mapping2.getOriginalInnerClassPrimaryConstructorByClass();
    }

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            CompilationExceptionKt.compilationException("Class is not inner", innerClass);
            throw null;
        }
        return MappingsKt.getOrPut(this.outerThisFieldSymbols, (IrDeclaration)innerClass, (Function0)new Function0<IrField>(innerClass, this){
            final /* synthetic */ IrClass $innerClass;
            final /* synthetic */ JsInnerClassesSupport this$0;
            {
                this.$innerClass = $innerClass;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrField invoke() {
                IrDeclarationParent irDeclarationParent = this.$innerClass.getParent();
                IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irClass2 == null) {
                    CompilationExceptionKt.compilationException("No containing class for inner class", this.$innerClass);
                    throw null;
                }
                IrClass outerClass2 = irClass2;
                IrFactory $this$buildField$iv = JsInnerClassesSupport.access$getIrFactory$p(this.this$0);
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = new IrFieldBuilder();
                boolean bl = false;
                IrFieldBuilder $this$invoke_u24lambda_u2d0 = $this$buildField_u24lambda_u2d4$iv;
                boolean bl2 = false;
                $this$invoke_u24lambda_u2d0.setOrigin(IrDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE);
                Name name = Name.identifier("$this");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"\\$this\")");
                $this$invoke_u24lambda_u2d0.setName(name);
                $this$invoke_u24lambda_u2d0.setType(IrUtilsKt.getDefaultType(outerClass2));
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
                $this$invoke_u24lambda_u2d0.setVisibility(descriptorVisibility);
                $this$invoke_u24lambda_u2d0.setFinal(true);
                $this$invoke_u24lambda_u2d0.setExternal(false);
                $this$invoke_u24lambda_u2d0.setStatic(false);
                IrField irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u2d4$iv);
                IrClass irClass3 = this.$innerClass;
                IrField it = irField;
                boolean bl3 = false;
                it.setParent(irClass3);
                return irField;
            }
        });
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        IrConstructor irConstructor2;
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = false;
            String $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)$i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22);
        }
        IrConstructor it = irConstructor2 = MappingsKt.getOrPut(this.innerClassConstructors, (IrDeclaration)innerClassConstructor, (Function0)new Function0<IrConstructor>(this, innerClassConstructor){
            final /* synthetic */ JsInnerClassesSupport this$0;
            final /* synthetic */ IrConstructor $innerClassConstructor;
            {
                this.this$0 = $receiver;
                this.$innerClassConstructor = $innerClassConstructor;
                super(0);
            }

            @NotNull
            public final IrConstructor invoke() {
                return JsInnerClassesSupport.access$createInnerClassConstructorWithOuterThisParameter(this.this$0, this.$innerClassConstructor);
            }
        });
        boolean bl2 = false;
        if (innerClassConstructor.isPrimary()) {
            this.originalInnerClassPrimaryConstructorByClass.set((IrClass)((IrDeclaration)innerClass), innerClassConstructor);
        }
        return irConstructor2;
    }

    @Override
    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)string2);
        }
        return this.originalInnerClassPrimaryConstructorByClass.get((IrClass)((IrDeclaration)innerClass));
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        void $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d5;
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irClass2 = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass2.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)irDeclarationParent2);
        Object $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d3 = $this$buildConstructor_u24lambda_u2d20$iv;
        boolean $i$a$-buildConstructor-JsInnerClassesSupport$createInnerClassConstructorWithOuterThisParameter$newConstructor$22 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d3.updateFrom(oldConstructor);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d3.setReturnType(oldConstructor.getReturnType());
        Object it = $this$buildConstructor$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2d20$iv);
        boolean bl2 = false;
        it.setParent(oldConstructor.getParent());
        it.setAnnotations(oldConstructor.getAnnotations());
        Object newConstructor2 = $this$buildConstructor$iv;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)newConstructor2, oldConstructor, null, null, 6, null);
        IrValueParameter[] irValueParameterArray = new IrValueParameter[1];
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d26$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $i$a$-buildConstructor-JsInnerClassesSupport$createInnerClassConstructorWithOuterThisParameter$newConstructor$22 = $this$buildValueParameter_u24lambda_u2d26$iv;
        int n = 0;
        Object[] objectArray = irValueParameterArray;
        boolean bl4 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d5.setOrigin(JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
        Name name = Name.identifier(Namer.INSTANCE.getOUTER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(Namer.OUTER_NAME)");
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d5.setName(name);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d5.setIndex(0);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d5.setType(outerThisType);
        objectArray[n] = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)newConstructor2).getFactory(), $this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)((IrDeclaration)newConstructor2)));
        List newValueParameters = CollectionsKt.mutableListOf((Object[])irValueParameterArray);
        for (IrValueParameter p : oldConstructor.getValueParameters()) {
            ((Collection)newValueParameters).add(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(p, (IrFunction)newConstructor2, null, p.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
        }
        ((IrFunction)newConstructor2).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)newConstructor2).getValueParameters(), (Iterable)newValueParameters));
        return newConstructor2;
    }

    public static final /* synthetic */ IrFactory access$getIrFactory$p(JsInnerClassesSupport $this) {
        return $this.irFactory;
    }

    public static final /* synthetic */ IrConstructor access$createInnerClassConstructorWithOuterThisParameter(JsInnerClassesSupport $this, IrConstructor oldConstructor) {
        return $this.createInnerClassConstructorWithOuterThisParameter(oldConstructor);
    }
}

