/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationChain;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public interface ConsumerVariantMatchResult {
    public boolean hasMatches();

    public Collection<ConsumerVariant> getMatches();

    public static class ConsumerVariant
    implements VariantDefinition {
        final ImmutableAttributes attributes;
        final Transformation transformation;
        final TransformationStep transformationStep;
        @Nullable
        final ConsumerVariant previous;
        final int depth;

        public ConsumerVariant(ImmutableAttributes attributes, TransformationStep transformationStep, @Nullable ConsumerVariant previous, int depth) {
            this.attributes = attributes;
            this.transformation = previous == null ? transformationStep : new TransformationChain(previous.transformation, transformationStep);
            this.transformationStep = transformationStep;
            this.previous = previous;
            this.depth = depth;
        }

        public String toString() {
            if (this.previous != null) {
                return this.previous + " <- (" + this.depth + ") " + this.transformationStep;
            }
            return "(" + this.depth + ") " + this.transformationStep;
        }

        @Override
        public ImmutableAttributes getTargetAttributes() {
            return this.attributes;
        }

        @Override
        public Transformation getTransformation() {
            return this.transformation;
        }

        @Override
        public TransformationStep getTransformationStep() {
            return this.transformationStep;
        }

        @Override
        @Nullable
        public VariantDefinition getSourceVariant() {
            return this.previous;
        }
    }
}

