/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "()V", "isIfExpression", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "isWhenExpression", "missingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getMissingCases", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)Ljava/util/List;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportElseMisplaced", "reportNotExhaustive", "whenExpression", "AlgebraicTypeKind", "checkers"})
public final class FirExhaustiveWhenChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirExhaustiveWhenChecker INSTANCE = new FirExhaustiveWhenChecker();

    private FirExhaustiveWhenChecker() {
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.reportNotExhaustive(expression2, context, reporter);
        this.reportElseMisplaced(expression2, reporter, context);
    }

    private final void reportNotExhaustive(FirWhenExpression whenExpression, CheckerContext context, DiagnosticReporter reporter) {
        if (ExhaustivenessStatusKt.isExhaustive(whenExpression)) {
            return;
        }
        KtSourceElement ktSourceElement = whenExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (whenExpression.getUsedAsExpression()) {
            if (this.isIfExpression(source)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            if (this.isWhenExpression(source)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), this.getMissingCases(whenExpression), (DiagnosticContext)context, null, 16, null);
            }
        } else {
            AlgebraicTypeKind algebraicTypeKind;
            Object object = whenExpression.getSubject();
            if (object == null || (object = ((FirExpression)object).getTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                return;
            }
            Object subjectType = object;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)subjectType, context.getSession()), context.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol subjectClassSymbol = firRegularClassSymbol;
            FirClassSymbol $this$modality$iv = subjectClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED) {
                algebraicTypeKind = AlgebraicTypeKind.Sealed;
            } else if (subjectClassSymbol.getClassKind() == ClassKind.ENUM_CLASS) {
                algebraicTypeKind = AlgebraicTypeKind.Enum;
            } else if (ConeBuiltinTypeUtilsKt.isBooleanOrNullableBoolean((ConeKotlinType)subjectType)) {
                algebraicTypeKind = AlgebraicTypeKind.Boolean;
            } else {
                return;
            }
            AlgebraicTypeKind kind = algebraicTypeKind;
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ProhibitNonExhaustiveWhenOnAlgebraicTypes)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), this.getMissingCases(whenExpression), (DiagnosticContext)context, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_EXHAUSTIVE_WHEN_STATEMENT(), (Object)kind.getDisplayName(), this.getMissingCases(whenExpression), (DiagnosticContext)context, null, 32, null);
            }
        }
    }

    private final List<WhenMissingCase> getMissingCases(FirWhenExpression $this$missingCases) {
        ExhaustivenessStatus exhaustivenessStatus = $this$missingCases.getExhaustivenessStatus();
        Intrinsics.checkNotNull((Object)exhaustivenessStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus.NotExhaustive");
        return ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus).getReasons();
    }

    private final void reportElseMisplaced(FirWhenExpression expression2, DiagnosticReporter reporter, CheckerContext context) {
        int branchesCount = expression2.getBranches().size();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)expression2.getBranches())) {
            FirWhenBranch branch = (FirWhenBranch)indexedValue.getValue();
            if (!(branch.getCondition() instanceof FirElseIfTrueCondition) || indexedValue.getIndex() >= branchesCount - 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)branch.getSource(), FirErrors.INSTANCE.getELSE_MISPLACED_IN_WHEN(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isIfExpression(KtSourceElement $this$isIfExpression) {
        return Intrinsics.areEqual((Object)$this$isIfExpression.getElementType(), (Object)KtNodeTypes.IF);
    }

    private final boolean isWhenExpression(KtSourceElement $this$isWhenExpression) {
        return Intrinsics.areEqual((Object)$this$isWhenExpression.getElementType(), (Object)KtNodeTypes.WHEN);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker$AlgebraicTypeKind;", "", "displayName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "Sealed", "Enum", "Boolean", "checkers"})
    private static final class AlgebraicTypeKind
    extends Enum<AlgebraicTypeKind> {
        @NotNull
        private final String displayName;
        public static final /* enum */ AlgebraicTypeKind Sealed = new AlgebraicTypeKind("sealed class/interface");
        public static final /* enum */ AlgebraicTypeKind Enum = new AlgebraicTypeKind("enum");
        public static final /* enum */ AlgebraicTypeKind Boolean = new AlgebraicTypeKind("Boolean");
        private static final /* synthetic */ AlgebraicTypeKind[] $VALUES;

        private AlgebraicTypeKind(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static AlgebraicTypeKind[] values() {
            return (AlgebraicTypeKind[])$VALUES.clone();
        }

        public static AlgebraicTypeKind valueOf(String value2) {
            return java.lang.Enum.valueOf(AlgebraicTypeKind.class, value2);
        }

        static {
            $VALUES = algebraicTypeKindArray = new AlgebraicTypeKind[]{AlgebraicTypeKind.Sealed, AlgebraicTypeKind.Enum, AlgebraicTypeKind.Boolean};
        }
    }
}

