/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import javax.annotation.Nullable;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.PhasedBuildActionResult;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.runner.AbstractClientProvidedBuildActionRunner;
import org.gradle.tooling.internal.provider.runner.BuildControllerFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class ClientProvidedPhasedActionRunner
extends AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    private final PayloadSerializer payloadSerializer;
    private final BuildEventConsumer buildEventConsumer;

    public ClientProvidedPhasedActionRunner(BuildControllerFactory buildControllerFactory, PayloadSerializer payloadSerializer, BuildEventConsumer buildEventConsumer) {
        super(buildControllerFactory, payloadSerializer);
        this.payloadSerializer = payloadSerializer;
        this.buildEventConsumer = buildEventConsumer;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof ClientProvidedPhasedAction)) {
            return BuildActionRunner.Result.nothing();
        }
        ClientProvidedPhasedAction clientProvidedPhasedAction = (ClientProvidedPhasedAction)action;
        InternalPhasedAction phasedAction = (InternalPhasedAction)this.payloadSerializer.deserialize(clientProvidedPhasedAction.getPhasedAction());
        return this.runClientAction(new ClientActionImpl(phasedAction, action), buildController);
    }

    private class ClientActionImpl
    implements AbstractClientProvidedBuildActionRunner.ClientAction {
        private final InternalPhasedAction phasedAction;
        private final BuildAction action;

        public ClientActionImpl(InternalPhasedAction phasedAction, BuildAction action) {
            this.phasedAction = phasedAction;
            this.action = action;
        }

        @Override
        public Object getProjectsEvaluatedAction() {
            return this.phasedAction.getProjectsLoadedAction();
        }

        @Override
        public Object getBuildFinishedAction() {
            return this.phasedAction.getBuildFinishedAction();
        }

        @Override
        public void collectActionResult(SerializedPayload serializedResult, PhasedActionResult.Phase phase) {
            PhasedBuildActionResult res = new PhasedBuildActionResult(serializedResult, phase);
            ClientProvidedPhasedActionRunner.this.buildEventConsumer.dispatch((Object)res);
        }

        @Override
        @Nullable
        public SerializedPayload getResult() {
            return null;
        }

        @Override
        public boolean isRunTasks() {
            return this.action.isRunTasks();
        }
    }
}

