/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.gradle.api.internal.collections.AbstractIterationOrderRetainingElementSource;
import org.gradle.api.internal.collections.IndexedElementSource;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;

public class ListElementSource<T>
extends AbstractIterationOrderRetainingElementSource<T>
implements IndexedElementSource<T> {
    private final Spec<AbstractIterationOrderRetainingElementSource.ValuePointer<T>> alwaysAccept = new Spec<AbstractIterationOrderRetainingElementSource.ValuePointer<T>>(){

        public boolean isSatisfiedBy(AbstractIterationOrderRetainingElementSource.ValuePointer<T> pointer) {
            return true;
        }
    };

    @Override
    public Iterator<T> iterator() {
        this.realizePending();
        return this.listIterator();
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new RealizedElementListIterator(this.getInserted(), this.alwaysAccept);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return Lists.newArrayList(this.listIterator()).listIterator(index);
    }

    @Override
    public List<? extends T> subList(int fromIndex, int toIndex) {
        return Lists.newArrayList(this.listIterator()).subList(fromIndex, toIndex);
    }

    private List<T> asList() {
        return Lists.newArrayList(this.listIterator());
    }

    @Override
    public T get(int index) {
        return this.asList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.asList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.asList().lastIndexOf(o);
    }

    @Override
    public boolean add(T element) {
        ++this.modCount;
        return this.getInserted().add(new AbstractIterationOrderRetainingElementSource.Element<T>(element));
    }

    @Override
    public boolean addRealized(T value) {
        return true;
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        ++this.modCount;
        return this.getInserted().add(this.cachingElement(provider));
    }

    @Override
    public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        ++this.modCount;
        return this.getInserted().add(this.cachingElement(provider));
    }

    private ListIterator<T> iteratorAt(int index) {
        ListIterator<T> iterator = this.listIterator();
        while (iterator.previousIndex() < index && iterator.hasNext()) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public void add(int index, T element) {
        ++this.modCount;
        ListIterator<T> iterator = this.iteratorAt(index - 1);
        if (iterator.nextIndex() != index) {
            throw new IndexOutOfBoundsException();
        }
        iterator.add(element);
    }

    @Override
    public T set(int index, T element) {
        ++this.modCount;
        ListIterator<T> iterator = this.iteratorAt(index - 1);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        T previous = iterator.next();
        iterator.set(element);
        return previous;
    }

    @Override
    public T remove(int index) {
        ++this.modCount;
        ListIterator<T> iterator = this.iteratorAt(index - 1);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        T previous = iterator.next();
        iterator.remove();
        return previous;
    }

    private class RealizedElementListIterator
    extends AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator
    implements ListIterator<T> {
        T previous;
        int listNextIndex;
        int listPreviousIndex;

        RealizedElementListIterator(List<AbstractIterationOrderRetainingElementSource.Element<T>> backingList, Spec<AbstractIterationOrderRetainingElementSource.ValuePointer<T>> acceptanceSpec) {
            super(backingList, acceptanceSpec);
            this.listNextIndex = 0;
            this.listPreviousIndex = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        private void updatePrevious() {
            for (int i = this.previousIndex; i >= 0; --i) {
                AbstractIterationOrderRetainingElementSource.Element candidate = (AbstractIterationOrderRetainingElementSource.Element)((Object)this.backingList.get(i));
                if (!candidate.isRealized()) continue;
                List collected = candidate.getValues();
                if (this.previousSubIndex == -1) {
                    this.previousSubIndex = collected.size();
                }
                for (int j = this.previousSubIndex - 1; j >= 0; --j) {
                    Object value = collected.get(j);
                    if (!this.acceptanceSpec.isSatisfiedBy(new AbstractIterationOrderRetainingElementSource.ValuePointer(candidate, j))) continue;
                    this.previousIndex = i;
                    this.previousSubIndex = j;
                    this.previous = value;
                    return;
                }
                this.previousSubIndex = -1;
            }
            this.previousIndex = -1;
            this.previous = null;
        }

        @Override
        public T next() {
            Object value = super.next();
            this.previous = ((AbstractIterationOrderRetainingElementSource.Element)((Object)this.backingList.get(this.previousIndex))).getValues().get(this.previousSubIndex);
            ++this.listNextIndex;
            ++this.listPreviousIndex;
            return value;
        }

        @Override
        public T previous() {
            this.checkForComodification();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.nextIndex = this.previousIndex;
            this.nextSubIndex = this.previousSubIndex;
            this.next = this.previous;
            this.updatePrevious();
            --this.listNextIndex;
            --this.listPreviousIndex;
            return this.next;
        }

        @Override
        public int nextIndex() {
            return this.listNextIndex;
        }

        @Override
        public int previousIndex() {
            return this.listPreviousIndex;
        }

        @Override
        public void set(T t) {
            if (this.previousIndex < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.backingList.set(this.previousIndex, new AbstractIterationOrderRetainingElementSource.Element(t));
        }

        @Override
        public void add(T t) {
            this.checkForComodification();
            AbstractIterationOrderRetainingElementSource.Element element = new AbstractIterationOrderRetainingElementSource.Element(t);
            this.backingList.add(this.nextIndex, element);
            ++this.nextIndex;
            this.previous = element.getValues().get(0);
            this.previousIndex = this.nextIndex;
            this.previousSubIndex = 0;
        }

        @Override
        public void remove() {
            super.remove();
            this.previous = null;
        }
    }
}

